package gov.va.vinci.dart.db;

import java.util.List;

import gov.va.vinci.dart.biz.Review;

public interface ReviewDAO {

	void save(final Review review);
	void delete(final Review review);
	Review findById(final int reviewId);
	List<Review> listAll();
	List<Review> listByRequestId(final int requestId);
	List<Review> listByRequestIdAndWorkflowId(final int requestId, final int workflowId);
	List<Review> listByWorkflowId(final int workflowid);
	List<Review> listByGroupId(final int groupId);
	List<Review> listByRequestIdAndGroupId(final int requestId, final int groupId);
}
